/* 
 *  MonitoredUserRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MonitoredUserNotFoundException;
import com.avaya.ccs.javafxrefclient.UserNotFoundException;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import java.util.List;

public abstract class MonitoredUserRequest extends UserRequest {

    private final String monitoredUserID;

    public MonitoredUserRequest(Logger LOG, String supervisorID, String monitoredUserID) {
        super(LOG, supervisorID);
        this.monitoredUserID = monitoredUserID;
    }

    /*
    If this methods throws an exeception the base request class will catch it.
     */
    public MonitoredUserI getMonitoredUser() throws InvalidArgumentException, ObjectInvalidException, UserNotFoundException, MonitoredUserNotFoundException {
        MonitoredUserI monitoredUser = null;
        UserI supervisor = getUser();

        List<MonitoredUserI> monitoredUsers = supervisor.getMonitoredUsers();
        for (MonitoredUserI usr : monitoredUsers) {
            if (usr.getId().equals(this.monitoredUserID)) {
                monitoredUser = usr;
            }
        }
        if (monitoredUser == null) {
            throw new MonitoredUserNotFoundException(supervisor.getId(), this.monitoredUserID);
        } else {
            return monitoredUser;
        }

    }

}
